/* #------------------------------------------------------------------------#
   |                                                                        |
   |   settype.c                                                            |
   |                                                                        |
   |   Set filetype on a file for RiscOS.                                   |
   |                                                                        |
   |   Copyright 2001, Frank A. Vorstenbosch                                |
   |                                                                        |
   #------------------------------------------------------------------------# */

/* $Id: settype.c,v 0.2 2001/12/22 12:19:51 frank Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Configurable options.                                                |
   |                                                                        |
   +------------------------------------------------------------------------+ */

static char Copyright[]="SETTYPE [0.00]  Copyright 1996, Frank A. Vorstenbosch";
static char FirstAid[]="Usage: SETTYPE [-v] file [type]";
static char FullHelp[]="Display or set RiscOS file type extended attribute..\n";


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Global data.                                                         |
   |                                                                        |
   +------------------------------------------------------------------------+ */

char inFileName[FILENAME_MAX],tempName[FILENAME_MAX];
int type=-1;
char Result[128];


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Subroutines.                                                         |
   |                                                                        |
   +------------------------------------------------------------------------+ */

extern int ncp(int function,void *si,int cx,void *di,int dx);

/* -------------------------------------------------------------------------- */

int make_path(char *nwpath,const char *name)
{  char *p,*size;
   const char *q;

   *nwpath=0;
   size=nwpath+1;
   p=nwpath+2;
   q=name;

   while(*q)
   {  (*nwpath)++;
      *size=0;
      while(*q && *q!=':' && *q!='/' && *q!='\\')
      {  *p++=*q++;
         (*size)++; }
      while(*q==':' || *q=='/' || *q=='\\')
         q++;
      size=p++;
   }

   return size-nwpath;
}

/* -------------------------------------------------------------------------- */

int GetDirEntry(long *Volume,long *DirEntry,const char *name,int lfn)
{  char *q,Name[128];
   int len;
   struct
   {  char Subfn,
           NameSpace,
           DestNameSpace,
           SearchAttributes[2],
           RIM[4],
           Volume,
           Directory[4],
           HandleFlag,
           PathComponents,
           Path[128];
   } Request;
   struct 
   {  char unused[48],
           dirEntNum[4],
           DosDirNum[4],
           volNumber[4],
           EADataSize[4],
           EAKeyCount[4],
           EAKeySize[4],
           NSCreator[4],
           nameLength,
           entryName[256];                 
   } Reply;

   if(ncp(lfn?0x7160:0x6000,(void *)name,0,(void *)Name,0))
      return -1;

   q=Name;

   if(q[0]!='\\' || q[1]!='\\')
      return -1;

   q+=2;
   while(*q && *q!='\\')
      q++;
   if(*q=='\\')
      q++;

   Request.Subfn=0x06;     /* get info */
   Request.NameSpace=Request.DestNameSpace=lfn?4:0;
   *((int *)&Request.SearchAttributes)=0x8006;
   *((long *)&Request.RIM)=0xfff;
   Request.Volume=0;
   *((long *)&Request.Directory)=0;
   Request.HandleFlag=255;

   len=make_path(&Request.PathComponents,q)+3*1+2+4+1+4+2*1;

   if(ncp(0xf257,&Request,len,&Reply,sizeof Reply))
      return -1;

   *Volume=*((long *)&Reply.volNumber);
   *DirEntry=*((long *)&Reply.dirEntNum);

   return 0;
}

/* -------------------------------------------------------------------------- */

int CloseEA(long handle)
{  struct
   {  char Subfn,
           Zero[2],
           Handle[4];
   } Request;
   struct
   {  char Data[1];
   } Reply;

   Request.Subfn=1;
   *((int *)&Request.Zero)=0;
   *((long *)&Request.Handle)=handle;

   return ncp(0xf256,&Request,1+2+4,&Reply,sizeof Reply);
}

/* -------------------------------------------------------------------------- */

int GetType(const char *name)
{  int i;
   struct
   {  char Subfn,
           Flags[2],
           Volume[4],
           DirEntry[4],
           Position[4],
           Length[4],
           Name[8];
   } Request;
   struct
   {  long Error,
           TotalLength,
           Handle,
           Access;
      int Length;
      int Value; 
   } Reply;

   if(GetDirEntry((long *)&Request.Volume,(long *)&Request.DirEntry,name,0))
      return -1;

   Request.Subfn=3;  /* read */
   *((int *)&Request.Flags)=0;
   *((long *)&Request.Position)=0;
   *((long *)&Request.Length)=2;
   memcpy(Request.Name,"\006\000riscos",8);

   if(ncp(0xf256,&Request,1+2+4*4+8,&Reply,sizeof Reply))
      return 0xfff;
   CloseEA(Reply.Handle);

   if(Reply.Length!=2)
      return 0xfff;

   return Reply.Value;
}

/* -------------------------------------------------------------------------- */

int SetType(const char *name,int type)
{  int i;
   struct
   {  char Subfn,
           Flags[2],
           Volume[4],
           DirEntry[4],
           Size[4],
           Position[4],
           Access[4],
           Length[2],
           Name[8],
           Value[2];
   } Request;
   struct
   {  long Error,
           BytesWritten,
           Handle;
   } Reply;

   if(GetDirEntry((long *)&Request.Volume,(long *)&Request.DirEntry,name,0))
      return -1;

   Request.Subfn=2; /* write */
   *((int *)&Request.Flags)=0;
   *((long *)&Request.Size)=2;
   *((long *)&Request.Position)=0;
   *((long *)&Request.Access)=0;
   *((int *)&Request.Length)=2;
   *((int *)&Request.Value)=type;
   memcpy(Request.Name,"\006\000riscos",8);

   if((i=ncp(0xf256,&Request,1+2+5*4+2+8+2,&Reply,sizeof Reply))==0)
      CloseEA(Reply.Handle);

   return i;
}
                

/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Main routine.                                                        |
   |                                                                        |
   +------------------------------------------------------------------------+ */

int main(int argc,char *argv[])
{  int i;
   char *p;

   if(i=1,argc==1 || (i=strcmp(argv[1],"?"))==0)
   {  
help: printf("%s\n\n%s\n",Copyright,FirstAid);
      if(!i)
         printf("\n%s",FullHelp);

      return 1;
   }

   for(i=1;i<argc;i++)
   {
      if(*argv[i]=='-')
      {  p=argv[i]+1;
         while(*p)
         {
            switch(*p)
            {  default:
                  printf("Unknown option -%c.\n",*p);
                  goto help;
            }
            p++;
         }
      }
      else
      {  if(*inFileName)
         {  
            if(type!=-1)
            {  printf("Can only set type for one file.\n");
               return 1; }
            sscanf(argv[i],"%x",&type);
         }
         else
            strcpy(inFileName,argv[i]);
      }
   }

   if(type!=-1)
      SetType(inFileName,type);
   else
      printf("%04x %s\n",GetType(inFileName),inFileName);

   return 0;
}


/* ----- EOF settype.c ----- */

