/* ͻ
                                                                        
      MBUF.H                                                            
                                                                        
      Mbuf manager data structures and entry points.                    
                                                                        
      Copyright 1999, Frank A. Vorstenbosch                             
                                                                        
   ͼ */


#ifndef __MBUF
#define __MBUF

struct pkthdr
{  int len;
   void *rcv_if; 
};

struct mbuf
{  struct mbuf *next,
               *list;
   int off,
       len,
       inioff,
       inilen;

   unsigned char type,
                 sys1,
                 sys2,
                 flags;
   struct pkthdr pkthdr;
};

#define mtod(mb,type) (type)((char *)mb+mb->off)

struct mbctl
{  int opaque,
       mbcsize,
       mbcvers,
       flags,
       advminubs,
       advmaxubs,
       mincontig,
       spare1,
       minubs,
       maxubs,
       maxcontig,
       spare2;

   struct mbuf *(*alloc)(struct mbctl *,int bytes, void *initializer);
   struct mbuf *(*alloc_g)(struct mbctl *,int bytes, void *initializer,int flags);
   struct mbuf *(*alloc_u)(struct mbctl *,int bytes, void *initializer);
   struct mbuf *(*alloc_s)(struct mbctl *,int bytes, void *initializer);
   struct mbuf *(*alloc_c)(struct mbctl *,int bytes, void *initializer);

   struct mbuf *(*ensure_safe)(struct mbctl *,struct mbuf *mp);
   struct mbuf *(*ensure_contig)(struct mbctl *,struct mbuf *mp,int bytes);

   void (*free)(struct mbctl *,struct mbuf *mp);
   void (*freem)(struct mbctl *,struct mbuf *mp);
   void (*dtom_free)(struct mbctl *,struct mbuf *mp);
   void (*dtom_freem)(struct mbctl *,struct mbuf *mp);
   void (*dtom)(struct mbctl *,void *data);
   int  (*any_unsafe)(struct mbctl *,struct mbuf *mp);
   int  (*this_unsafe)(struct mbctl *,struct mbuf *mp);
   int  (*count_bytes)(struct mbctl *,struct mbuf *mp);

   struct mbuf *(*cat)(struct mbctl *,struct mbuf *old,struct mbuf *new);
   struct mbuf *(*trim)(struct mbctl *,struct mbuf *mp,int bytes,void *data);
   struct mbuf *(*copy)(struct mbctl *,struct mbuf *mp,int offset,int bytes);
   struct mbuf *(*copy_p)(struct mbctl *,struct mbuf *mp,int offset,int bytes);
   struct mbuf *(*copy_u)(struct mbctl *,struct mbuf *mp,int offset,int bytes);

   struct mbuf *(*import)(struct mbctl *,struct mbuf *mp,int bytes,void *data);
   struct mbuf *(*export)(struct mbctl *,struct mbuf *mp,int bytes,void *data);
};

#endif

/*  EOF  */

