; ͻ
;                                                                      
;    IPX.I                                                             
;                                                                      
;    Defines shared between all NWClient and RiscIPX asm code.         
;                                                                      
;    Copyright 1998, Frank A. Vorstenbosch                             
;                                                                      
; ͼ
;
; File created 15-dec-98

IPX_HEX_VERSION = 0x00154
IPX_VERSION     = ((IPX_HEX_VERSION/256)%16)*100+((IPX_HEX_VERSION/16)%16)*10+((IPX_HEX_VERSION)%16)

IPX_SWIBASE     = 0xcf00
NCP_SWIBASE     = 0xcf40

NWFS_ID         = 143   ; some random number<256

; Ŀ
;                                                                      
;    Macros for accessing the IPX function table.                      
;                                                                      
; 

;  IPX_SETUP 
; In:  bad - label where to jump if IPX not loaded
; Act: Check whether RiscIPX has been loaded, and if so, set up table
;      of function pointers.
; Out: R4 - pointer to struct RiscIPX
;      R5-R12 preserved

                .macro  IPX_SETUP,bad
                swix    IPX_SWIBASE+63              ; get ipx function table
                bvs     \&bad
                cmp     r0,#IPX_VERSION             ; R0=version
                blo     \&bad
                cmp     r2,(IPXS_FnTableEnd-IPXS_FnTable)>>2  ; R2=number of functions in table
                blo     \&bad

                mov     r2,(IPXS_FnTableEnd-IPXS_FnTable)>>2  ; the number that we can cope with
IPXS_lea:       add     r0,pc,IPXS_FnTable-IPXS_lea-8
                .ifdef DEBUG
                swi     Trace_R0
                .endif
IPXS_CopyFn:    ldr     r5,[r1],#4
                .ifdef DEBUG
                swi     Trace_NewLine
                swi     Trace_R5
                .endif
                sub     r5,r5,r0
                sub     r5,r5,#8
                mov     r5,r5,LSL #8
                mov     r5,r5,ASR #2
                mov     r5,r5,LSR #8
                orr     r5,r5,#0xea000000           ; B instruction
                .ifdef DEBUG
                swi     Trace_R5
                .endif
                str     r5,[r0],#4
                loop    r2,IPXS_CopyFn

                lea     r1,IPXS_FnTable
                lea     r2,IPXS_FnTableEnd
                mov     r0,#1
                swix    OS_SynchroniseCodeAreas     ; flush cache
                .endm


;  IPX_TABLE 

                .macro  IPX_TABLE
                public  _ipx_socket
                public  _ipx_close
                public  _ipx_recv_handler
                public  _ipx_bind
                public  _ipx_listen
                public  _ipx_accept
                public  _ipx_connect
                public  _ipx_recv
                public  _ipx_send
                public  _ipx_recv_mbuf
                public  _ipx_send_mbuf
                public  _ipx_send_unsafe
                public  _ipx_send_pack
                public  _Pack
                public  _PackN
                public  _PackB
                public  _Unpack
                public  _UnpackN
                public  _UnpackB
                public  _CountPack
                public  _malloc
                public  _free
                public  _memcpy
                public  _memcmp
                public  _sleep10ms
                public  _AtoIPX
                public  _ipx_getport
                public  _ipx_get_mtu

IPXS_FnTable:
_ipx_socket:	        mov     pc,#0
_ipx_close:	        mov     pc,#0
_ipx_recv_handler:	mov     pc,#0
_ipx_bind:	        mov     pc,#0
_ipx_listen:	        mov     pc,#0
_ipx_accept:	        mov     pc,#0
_ipx_connect:	        mov     pc,#0
_ipx_recv:	        mov     pc,#0
_ipx_send:	        mov     pc,#0
_ipx_recv_mbuf:	        mov     pc,#0
_ipx_send_mbuf:	        mov     pc,#0
_ipx_send_unsafe:	mov     pc,#0
_ipx_send_pack:	        mov     pc,#0
_Pack:	        mov     pc,#0
_PackN:	        mov     pc,#0
_PackB:	        mov     pc,#0
_Unpack:	        mov     pc,#0
_UnpackN:	        mov     pc,#0
_UnpackB:	        mov     pc,#0
_CountPack:	        mov     pc,#0
_malloc:	        mov     pc,#0
_free:	        mov     pc,#0
_memcpy:	        mov     pc,#0
_memcmp:	        mov     pc,#0
_sleep10ms:	        mov     pc,#0
_AtoIPX:	        mov     pc,#0
_ipx_getport:           mov     pc,#0
_ipx_get_mtu:           mov     pc,#0
IPXS_FnTableEnd:
                .endm


;  IPX_MESSAGE 

                .macro  IPX_MESSAGE
                dd      2
                db      "RiscIPX is not loaded or incompatible version (need "
                db      '0'+(IPX_VERSION/100)%10
                db      "."
                db      '0'+(IPX_VERSION/10)%10
                db      '0'+(IPX_VERSION)%10
                db      ")",0
                align
                .endm

;  EOF IPX.I 

