/* ͻ
                                                                        
      GATEWAY.H                                                         
                                                                        
      IPX Gateway data structures.                                      
                                                                        
      Copyright 1999, Frank A. Vorstenbosch.                            
                                                                        
   ͼ */


#include "pragmas.h"
#include "riscipx.h"
#include "lists.h"
#include "debug.h"
#include "../libmod.h"
#include "sap.h"


/* Ŀ
                                                                        
      Static data.                                                      
                                                                        
    */

struct GateWay
{  int TaskHandle;   /* must be at offset 0 for assembly code to work */

   struct RiscIPX *ri;

   LIST Servers;
   struct Socket *SapSocket;

   int Packet;

   int Buffer[256/sizeof(int)];
};

/*  */

struct Server
{  NODE;

   unsigned short ServerType,
                  HopCount;
   char Name[48];

   int Destroy;   /* when we'll forget about this SAP */
   char Origin;   /* bitmask of frame types we saw this SAP on */
};


/* Ŀ
                                                                        
      Function prototypes.                                              
                                                                        
    */

/*  gateway.arm  */

extern char Version[4];
extern char ModuleName[];

/*  gate.c  */

extern struct GateWay *gateway_init(struct RiscIPX *ri);
extern struct kernel_error *gateway_exit(register struct GateWay *gw);
extern void gateway(register struct GateWay *gw,const char *commandTail);


/*  subgate.arm  */

extern struct kernel_error *StarStatus(const char *commandTail,int numParms,struct GateWay *gw);
extern struct kernel_error Error_SapSocket;


/*  EOF GATEWAY.H  */

