/* #------------------------------------------------------------------------#
   |                                                                        |
   |   FILER.H                                                              |
   |                                                                        |
   |   NWClient filer data structures.                                      |
   |                                                                        |
   |   Copyright 1998, Frank A. Vorstenbosch.                               |
   |                                                                        |
   #------------------------------------------------------------------------#

   File created 16-dec-98   */


#include "pragmas.h"
#include "riscipx.h"
#include "lists.h"
#include "services.h"
#include "debug.h"
#include "../libmod.h"


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   RiscOS structures.                                                   |
   |                                                                        |
   +------------------------------------------------------------------------+ */

struct MenuItem
{  int Flags,
       *Handle,
       IconFlags;
   char Name[12];
};

struct Menu
{  char Name[12];
   int Colours,
       Width,
       Height,
       Gap;
   struct MenuItem Items[8];
};


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Static data.                                                         |
   |                                                                        |
   +------------------------------------------------------------------------+ */

struct Filer
{  int TaskHandle,   /* must be at offset 0 for assembly code to work */
       FilerHandle;  /* must be at offset 4 for assembly code to work */

   int ServiceR0,    /* the cause for the service call   */
       ServiceR2;    /* parameter to the service call    */

   LIST Icons;

   int *InfoTemplate,
       *LoginTemplate, 
       *MountTemplate, 
       *AttachTemplate,
       *InfoWindow,
       *LoginWindow,
       *MountWindow,
       *AttachWindow;

   char XShift,
        YShift;
   int Width,
       Height,
       Run,       /* interval for PollIdle, or 0 if we want to quit */
       ThisMenu,
       Flags;
       #define FILER_MORESERVERS    (1<<0)

   int MessageFile[4],
       *Messages;

   struct Icon *CurrentIcon;

   struct Menu Menu;

   int Buffer[256/sizeof(int)];
};


/* -------------------------------------------------------------------------- */

struct Icon
{  NODE;
   /* ..... wimp icon data ..................................................... */
   int Window,                /* window handle                                */
       MinX,MinY,MaxX,MaxY,   /* bounding box                                 */
       Flags;                 /* wimp icon flags                              */
   const char *Text,          /* text to display for icon                     */
              *Sprite;        /* name of sprite to display                    */
   int Length;                /* unused                                       */
   /* ..... our variables ...................................................... */
   int Icon,                  /* icon handle                                  */
       Mount,                 /* mount point                                  */
       Server;                /* server handle                                */
   const char *MountPoint;    /* directory on file server for this mount      */
                              /* or server name if MODE_LOGIN                 */
   char MountCount,           /* mount count                                  */
        MountFlags,           /* mount flags                                  */
        IconPosition,         /* relative position of icon                    */
        Mode;                 /* which type of icon                           */
      #define MODE_ATTACH  0
      #define MODE_LOGIN   1
      #define MODE_MOUNT   2
      #define MODE_OPEN    3
};


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Function prototypes.                                                 |
   |                                                                        |
   +------------------------------------------------------------------------+ */

/* ----- nwfiler.arm -------------------------------------------------------- */

extern char Version[4];

/* ----- filer.c ------------------------------------------------------------ */

extern struct Filer *filer_init(void);
extern void filer_exit(register struct Filer *nf);
extern int filer(register struct Filer *nf,const char *commandTail);
extern void filer_servicecall(int r0,register struct Filer *nf,int r2);
extern void filer_modechange(register struct Filer *nf);


/* ----- subfiler.arm ------------------------------------------------------- */

extern char constServer[];
extern char tokenServer[];
extern char constAttach[];
extern char tokenAttach[];
extern char constDetach[];
extern char tokenDetach[];
extern char constLogin[];
extern char tokenLogin[];
extern char constLogout[];
extern char tokenLogout[];
extern char constMount[];
extern char tokenMount[];
extern char constDismount[];
extern char tokenDismount[];
extern char constInfo[];
extern char tokenInfo[];
extern char constFree[];
extern char tokenFree[];
extern char constQuit[];
extern char tokenQuit[];

extern int SwiNumberFromString(const char *swiname);
extern struct kernel_error *SpriteOp(int func,int *area,...);
extern struct kernel_error *GetSpriteSize(const char *name,int *area,int *width,int *height);
extern struct kernel_error *ReadModeVariable(int mode,int var,int *result);

extern struct kernel_error *CallASwi(int swi,int *r0,int *r1,int *r2);

/* access an indirected string */
#define indirect(template,icon) ((char *)(template[22+icon*8+5]))

/* ..... glue code to NWClient module ....................................... */

extern struct kernel_error *Attach(const char *Name,int Mode,int *Server);
extern struct kernel_error *Detach(int Server);
extern struct kernel_error *Login(const char *Name,const char *Password);
extern struct kernel_error *Logout(int Server);
extern struct kernel_error *Mount(const char *Local,const char *Remote,int Flags,int *Mount);
extern struct kernel_error *Dismount(int Mount);
extern struct kernel_error *ServerList(int *server,char **name,char **user,int *flags);
extern struct kernel_error *MountList(int *mount,char **local,char **remote,int *flags,int *count,int *serverid);


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   Debugging.                                                           |
   |                                                                        |
   +------------------------------------------------------------------------+ */

#ifdef DEBUG
extern void ShowError(char *,int);
#else
#define ShowError(i) do {} while(0)
#endif


/* ----- EOF FILER.H ----- */

