
/* Ŀ
                                                                        
      Debugging.                                                        
                                                                        
    */

#ifdef DEBUG

_Asm void Break(void)
{
   swi 0xbf0f
   swi 0xa781
};

_Asm void TraceVal(int val)
{  % reg val
   .ifeqs  "val","%r0"
   swi   0xbf00 ; Trace_R0
   .endif
   .ifeqs  "val","%r1"
   swi   0xbf01 ; Trace_R1
   .endif
   .ifeqs  "val","%r2"
   swi   0xbf02 ; Trace_R2
   .endif
   .ifeqs  "val","%r3"
   swi   0xbf03 ; Trace_R3
   .endif
   .ifeqs  "val","%r4"
   swi   0xbf04 ; Trace_R4
   .endif
   .ifeqs  "val","%r5"
   swi   0xbf05 ; Trace_R5
   .endif
   .ifeqs  "val","%r6"
   swi   0xbf06 ; Trace_R6
   .endif
   .ifeqs  "val","%r7"
   swi   0xbf07 ; Trace_R7
   .endif
   .ifeqs  "val","%r8"
   swi   0xbf08 ; Trace_R8
   .endif
   .ifeqs  "val","%r9"
   swi   0xbf09 ; Trace_R9
   .endif
   .ifeqs  "val","%sb"
   swi   0xbf09 ; Trace_R9
   .endif
   .ifeqs  "val","%r10"
   swi   0xbf0a ; Trace_R10
   .endif
   .ifeqs  "val","%sl"
   swi   0xbf0a ; Trace_R10
   .endif
   .ifeqs  "val","%r11"
   swi   0xbf0b ; Trace_R11
   .endif
   .ifeqs  "val","%fp"
   swi   0xbf0b ; Trace_R11
   .endif
   .ifeqs  "val","%r12"
   swi   0xbf0c ; Trace_R12
   .endif
   .ifeqs  "val","%ip"
   swi   0xbf0c ; Trace_R12
   .endif
   .ifeqs  "val","%r13"
   swi   0xbf0d ; Trace_R13
   .endif
   .ifeqs  "val","%sp"
   swi   0xbf0d ; Trace_R13
   .endif
   .ifeqs  "val","%r14"
   swi   0xbf0e ; Trace_R14
   .endif
   .ifeqs  "val","%lr"
   swi   0xbf0e ; Trace_R14
   .endif
};

_Asm void TraceByte(int val)
{  % reg val
   .ifeqs  "val","%r0"
   swi   0xbf20 ; Trace_R0B
   .endif
   .ifeqs  "val","%r1"
   swi   0xbf21 ; Trace_R1B
   .endif
   .ifeqs  "val","%r2"
   swi   0xbf22 ; Trace_R2B
   .endif
   .ifeqs  "val","%r3"
   swi   0xbf23 ; Trace_R3B
   .endif
   .ifeqs  "val","%r4"
   swi   0xbf24 ; Trace_R4B
   .endif
   .ifeqs  "val","%r5"
   swi   0xbf25 ; Trace_R5B
   .endif
   .ifeqs  "val","%r6"
   swi   0xbf26 ; Trace_R6B
   .endif
   .ifeqs  "val","%r7"
   swi   0xbf27 ; Trace_R7B
   .endif
   .ifeqs  "val","%r8"
   swi   0xbf28 ; Trace_R8B
   .endif
   .ifeqs  "val","%r9"
   swi   0xbf29 ; Trace_R9B
   .endif
   .ifeqs  "val","%sb"
   swi   0xbf29 ; Trace_R9B
   .endif
   .ifeqs  "val","%r10"
   swi   0xbf2a ; Trace_R10B
   .endif
   .ifeqs  "val","%sl"
   swi   0xbf2a ; Trace_R10B
   .endif
   .ifeqs  "val","%r11"
   swi   0xbf2b ; Trace_R11B
   .endif
   .ifeqs  "val","%fp"
   swi   0xbf2b ; Trace_R11B
   .endif
   .ifeqs  "val","%r12"
   swi   0xbf2c ; Trace_R12B
   .endif
   .ifeqs  "val","%ip"
   swi   0xbf2c ; Trace_R12B
   .endif
   .ifeqs  "val","%r13"
   swi   0xbf2d ; Trace_R13B
   .endif
   .ifeqs  "val","%sp"
   swi   0xbf2d ; Trace_R13B
   .endif
   .ifeqs  "val","%r14"
   swi   0xbf2e ; Trace_R14B
   .endif
   .ifeqs  "val","%lr"
   swi   0xbf2e ; Trace_R14B
   .endif
};

_Asm void TraceChar(int val)
{  % reg val
   mov   %r0,val
   swi   0xbf11 ; Trace_WriteC
   % con val
   mov   %r0,#(val&0xff)
   swi   0xbf11 ; Trace_WriteC
};

_Asm void _Trace(const char *text)
{  % reg text
   mov   %r0,text
   swi   0xbf14 ; Trace_Write0
};
#define Trace(text) do { const char *msg=text; _Trace(msg); } while(0)

_Asm void _TraceMem(const void *data,int len)
{  % reg data,len
   mov   %r0,data
   mov   %r1,len
   swi   0xbf1a ; Trace_MemB
};
#define TraceMem(d,l) do { const void *data=d; int len=l; _TraceMem(data,len); } while(0)

#else
#define Trace(msg)      do {} while(0)
#define TraceVal(i)     do {} while(0)
#define TraceByte(i)    do {} while(0)
#define TraceChar(i)    do {} while(0)
#define TraceMem(d,l)   do { } while(0)
#define Break()         do {} while(0)
#endif

/*  EOF  */

